<?php 
/**
* Note: This file may contain artifacts of previous malicious infection.
* However, the dangerous code has been removed, and the file is now safe to use.
*/


// csv_update.php
// NOTE: Make sure to include CORS headers if needed:
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: X-Requested-With, Content-Type, Authorization");

// 1. Read JSON from the request body
$jsonString = file_get_contents('php://input');
$data = json_decode($jsonString, true);

// 2. Check we have 'jobs'
if (!empty($data['jobs']) && is_array($data['jobs'])) {
    // 3. Open CSV in append mode
    $file = fopen('csvlinks.csv', 'a');
    if (!$file) {
        exit("ERROR: Can't open 'csvlinks.csv' for writing.");
    }

    // 4. For each job, append a new row
    foreach ($data['jobs'] as $job) {
        // Extract columns, ensuring we handle missing keys
        $website = isset($job['website']) ? $job['website'] : "";
        $title = isset($job['title']) ? $job['title'] : "";
        $description = isset($job['description']) ? $job['description'] : "";
        $url = isset($job['url']) ? $job['url'] : "";
        $location = isset($job['location']) ? $job['location'] : "";

        // Write CSV row: columns in the order you like
        // e.g. [website, title, description, url, location]
        fputcsv($file, [$website, $title, $description, $url, $location]);
    }

    fclose($file);
    echo "Appended " . count($data['jobs']) . " jobs to CSV.";
} else {
    echo "No 'jobs' array found or it's empty.";
}
